# TALT Datasæt

Denne mappe indeholder TALT projektets samlede datasæt til offentliggørelse. Data er **syntetisk** data indsamlet og genereret i forbindelse med og i forberedelse til afprøvning af projektets prototyper. 

For yderligere information om data se projektets supplerende dokumentation 'Syntetiske data' og 'Data og modeller' tilgængelig på sitet [talegenkendelse.dk](https://talegenkendelse.dk). Her kan du også finde dokumentet 'Vej til drift' der er en større redegørelse for det tekniske arbejde i projektet.

## UC1: Sygeplejefaglig udredning datasæt

Til projektets første use case er to datasæt indsamlet, brugt til forskellige formål.

Det første datasæt (**afproevning**) er en samling af **syntetiske** sygeplejefaglige udredningssamtaler indsamlet i forbindelse med afprøvninger af løsningen. De er genereret af det faglige personale der har deltaget ved afprøvningerne. Datasættet er benyttet til evaluering af performance og optimering af prompts til generering af sygeplejetiltandsnotater.

Det andet datasæt (**synthetic**) er en samling af syntetiske sygeplejefaglige udredningssamtaler indsamlet via den syntetiske data generering. Datasættet er benyttet til træning af classification modellen.


Hver datasæt indeholder følgende to tabeller med tilhørende kolonne beskrivelser:

**conversations.parquet**
- **conversation_id**: ID på samtalen
- **line_number**: Linjenummeret i den enkelte samtale
- **line_text**: Tekstindholdet af linjen
- **health_condition**: Sygeplejetilstanden(e) for linjen
- **speaker**: Taler for linjen (UNUSED)
- **health_condition_edited**: Valideret sygeplejetilstand (hvis tilgængelig)
- **text_edited**: Valideret linje indhold (hvis tilgængelig)

**summarizations.parquet**
- **conversation_id**: ID på samtalen
- **health_condition**: Sygeplejetilstanden for notatet
- **summarization**: Udkast til notat
- **summarization_edited**: Redigerede notat (hvis tilgængelig)
- **validation**: Valideringsstatus (hvis tilgængelig)
- **validation_comment**: Kommentar til validering (hvis tilgængelig)
- **irrelevant**: Markering af relevans fra fagpersonale

Tabellerne kan indlæses som dataframes med Pandas-biblioteket i Python:
```python
import pandas as pd
df_conversations_afproevning = pd.read_parquet('UC1/uc1_afproevning_conversations.parquet')
df_summaries_afproevning = pd.read_parquet('UC1/uc1_afproevning_summarizations.parquet')
df_conversations_synthetic = pd.read_parquet('UC1/uc1_synthetic_conversations.parquet')
df_summaries_synthetic = pd.read_parquet('UC1/uc1_synthetic_summarizations.parquet')
```

## UC2 - Journalopsummeringer

Dette datasæt er en samling **syntetiske** journal-data udarbejdet af fagligt personale i projektet og har til formål at understøtte udvikling og afprøvning af projektes anden use case. Use casen omhandler opsummering af borgerjournaler, hvorfor dette datasæt også kobler journal-data til vores løsnings opsummeringer og det faglige personales feedback indhentet i forbindelse med interne og eksterne afprøvninger af prototypen

Dataen er opdelt i tre parquet-filer: **journals.parquet**, **journals_observations.parquet** og **journals_feedback.parquet**.\

**journals.parquet** er tabellen, der samler journal-data og genererede opsummeringer i enkelte rækker for hver journal, med undtagelse af observationerne, da journalerne har en en-til-mange relation til deres observationer, har observationerne derfor fået deres egen tabel.\
Den har følgende kolonner:

- **journal_id**: Journalens id
- **name**: Borgerens navn
- **municipality**: Kommune, der har gennereret journalen
- **journal_created_date**: Dato for oprettelse af journal database
- **health_information**, **motivation**, **habits**, **mastering**, **resources**: Journalkolonner omhandlende generel information om borgeren
- **problems_with_xx** and **xx_problems**: Journaldata for de 23 helbredstilstande under de 12 sygeplejefaglige problemomårder (SPO)
- **visiting_context**: Besøgskontekst (relateret til sygeplejerskernes besøg)
- **xx_id**, **xx_generated**, **xx_manual**: summary_id, LLM-genereret opsummering og manuel-fagligt genereret opsummering for enten sygeplejerskebesøg (**summarization**) eller SSH-/SSA-besøg (**summarization_morning**, **summarization_noon**, **summarization_evening** and **summarization_night**)

**'journals_observations.parquet'**-tabellen indeholder alle observationer for journalerne, hvor hver række svarer til en observation hos en borger. Hver observation tilhører en bestemt journal gennem 'journal_id'-værdien. Den har følgende kolonner:
- **journal_id**: Journal-id, der relaterer til journal_id'et i 'journals_parquet'-tabellen. 
- **observation_header**: Observations overskrift
- **observation_text**: Observationens tekst
- **observation_type**: Observationens type; klinisk eller vigtig
- **creation_date**: Dato observationen er oprettet
- **execution_date**: Udførelsesdato for observationen


**'journals_feedback.parquet'** indeholder faglig feedback af opsummeringer fra afprøvninger. Hver række indeholder en evaluering og relaterer til en opsummering i 'journals.parquet'-tabellen gennem 'summary_id'. Tabellen har følgende kolonner:

- **summary_id**: Opsummeringens id, der relaterer til en opsummering i tabellen 'journals.parquet'. 
- **username**: Brugernavn på brugeren, der har leveret feedback (typisk kommunenavn)
- **validation_comment**: Kvalitativ feedback på opsummeringen
- **rating**: Rating af opsummeringen

Tabellerne kan indlæses som dataframes med Pandas-biblioteket i Python:
```
df_journals = pd.read_parquet("journals.parquet")
df_observations = pd.read_parquet("journals_observations.parquet")
df_feedback = pd.read_parquet("journals_feedback.parquet")
```

## UC3: Indtaling af besøgsbeskrivelser

Dette datasæt er en samling **syntetiske** besøgsbeskrivelser indsamlet i forbindelse med afprøvning af løsningen. De er genereret af det faglige personale der har deltaget ved afprøvningerne. De er organiseret i `collections` af besøgsbeskrivelser, hvor hver række i en given `collection` repræsenterer forskellige versioner af den samme besøgsbeskrivelse. Datasættet er benyttet til evaluering af performance.

Versionen er indikeret med kolonnen `plan_status` og har følgende værdier:
- `original`: Udkastet fra løsningen
- `edited`: Det tilrettede udkast
- `updated`: Den opdaterede beskrivelse baseret på `edited` versionen
- `updated_edited`: Det tilrettede opdaterede beskrivelse


Datasættet indeholder en tabel **uc3_besoegsbeskrivelser.parquet** og følgende kolonner med tilhørende beskrivelse:
- **collection_username**: Kommunenavn på samlingen
- **collection_id**: ID for samlingen
- **collection_started_at**: Oprettelsestidspunkt for samlingen
- **collection_completed_at**: Færdiggørelsestidspunkt for samlingen
- **collection_name**: Navn for samlingen
- **collection_visitation_time**: Tidspunkt på dagen for besøget [morgen, middag, aften, nat]
- **collection_progress_status**: Status på samlingen [completed]
- **visitation_plan_id**: Unikt ID for besøgsbeskrivelsen
- **transcription**: Transskription af indtaling
- **visitation_plan**: Tekstindholdet af besøgsbeskrivelsen
- **plan_status**: Version af besøgsbeskrivelsen [original, edited, updated, updated_edited]
- **plan_created_at**: Oprettelsestidspunkt for besøgsbeskrivelsen
- **plan_computed_at**: Beregningstidpunkt for besøgsbeskrivelsen
- **feedback_username**: Brugernavn på feedback
- **feedback_text**: Tekstindhold på feedback
- **rating**: Feedback reting (1-4)
- **feedback_created_at**: Tidspunkt for feedback
- **audio_duration**: Længde på indtaling (sekunder)


Tabellerne kan indlæses som dataframes med Pandas-biblioteket i Python:
```python
import pandas as pd
data = pd.read_parquet('UC3/uc3_besoegsbeskrivelser.parquet')
```
